require( "scripts/style.lua" );

SetConfirmExitCanShow(false);
SetGamePause(true);
SetPanelSpritePause(true);

MakeDialog
{
    name="quitwindow",
    Bitmap
    {
        image="ui/surfaces/panel",
        x=kCenter,
        y=kCenter,


        SetStyle(CreateTextStyle(FontGame, 28, RedColor)),
        Text
        {
            x=160,y=22,w=kMax,h=30,
            flags = kVAlignCenter + kHAlignLeft,
            name = "yesnotitle",
            label= "quittitle",
        },

        SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
        Text
        {
            x=0,y=kCenter - 20,
            name = "yesnobody",
            label= "quitconfirm",
        },

        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            close = true,
            flags = 5,
            name = yesname,
            x = kCenter-80,
            y = kMax-100,
            default=true,
            command=
                function()
                        PostMessage( CreateNamedMessage( kQuitNow, "QuitByMenu" ) );
                end,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"yes", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"yes", 0, 0),
        },

        Button
        {
            close = true,
            flags = 5,
            name = noname,
            x = kCenter+80,
            y = kMax-100,
            command=
                function() 
                    SetConfirmExitCanShow(true);
                    SetGamePause(false);
                    SetPanelSpritePause(false);
                    PlaySound("audio/sfx/menu/switch_screen.ogg");
                end,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"no", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"no", 0, 0),
        },
    },
} -- MakeDialog
